


package w83b.w83bOperacionesPaso.w83bListados.w83bActas;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bListadosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaReqMesaActasExcelAction extends Q70ActionPasoOP{


	
	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processOP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processForward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListReqMesasActas.xls";
		InputStream inputStream = W83bTablaReqMesaActasExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaLibroRegActas = (ArrayList)contexto.get("w83bResultadoListadosBean");
        W83bListadosBean listadoReqMesaBean = (W83bListadosBean)contexto.get("w83bListadosBean");                        
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);                        

        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);                        
        
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);                        
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));                        
        
        HashMap mapaReqMesa=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);                        
        
        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1                        
        HSSFCell cell = row.createCell((short)3);                        
        row = sheet.getRow((short)4);                        
        cell = row.getCell((short)4);                        
        
        StringBuffer tituloImagenEs = (StringBuffer)mapaReqMesa.get("tituloDepEs");                        
        StringBuffer tituloImagenEu =  (StringBuffer)mapaReqMesa.get("tituloDepEu");                        
        cell.setCellValue(tituloImagenEu.toString());                        
        
        cell = row.getCell((short)7);                        
        cell.setCellValue(tituloImagenEs.toString());                        
        
        tituloImagenEs = (StringBuffer)mapaReqMesa.get("tituloDelelegacionEs");                        
        tituloImagenEu = (StringBuffer)mapaReqMesa.get("tituloDelelegacionEu");                        
        
        row = sheet.getRow((short)6);                        
        cell = row.getCell((short)4);                        
        cell.setCellValue(tituloImagenEu.toString());                        
        
        cell = row.getCell((short)7);                        
        cell.setCellValue(tituloImagenEs.toString());                        
        
        row = sheet.getRow((short)9);                        
        cell = row.getCell((short)0);                        
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.listadosRequerimiento").toUpperCase());                        
        
        //MAPEO FORMULARIO
        row = sheet.getRow((short)W83bClsConstantes.DOCE); 
        cell = row.getCell((short)1);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.territorio"));
        
        cell = row.createCell((short)2); 
        if(StringUtils.isNotEmpty((listadoReqMesaBean.getDescTerritorio()))){
        	cell.setCellValue(listadoReqMesaBean.getDescTerritorio().toUpperCase());
		}
        
        cell = row.getCell((short)5);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.fechaEntradaDesde"));
        
        cell = row.createCell((short)7);
        if(StringUtils.isNotEmpty((listadoReqMesaBean.getFechaEntradaDesde()))){
        	cell.setCellValue(listadoReqMesaBean.getFechaEntradaDesde());
        }
        cell = row.getCell((short)9);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.fechaEntradaHasta"));
        
        cell = row.createCell((short)12); 
        if(StringUtils.isNotEmpty((listadoReqMesaBean.getFechaEntradaHasta()))){
        	cell.setCellValue(listadoReqMesaBean.getFechaEntradaHasta());
        }
        
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)
        row = sheet.getRow((short)W83bClsConstantes.QUINCE);
        cell = row.getCell((short)0);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.tabla.fech_entrada"));
        
        cell = row.getCell((short)1);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.nEntrada"));
        
        cell = row.getCell((short)2);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.tabla.num_preaviso"));
        
        cell = row.getCell((short)3);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.cif"));
        
        cell = row.getCell((short)4);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.nCentro"));
        
        cell = row.getCell((short)5);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.razonSocial"));
        
        cell = row.getCell((short)7);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.registroDefinitivo.direccion"));
        
        cell = row.getCell((short)9);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.municipio"));
        
        cell = row.getCell((short)11);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.registroDefinitivo.comarcaEntero"));
        
        cell = row.getCell((short)13);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.nTrabajadoresCorto"));
        
        cell = row.getCell((short)14);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.numRepresentantesCorto"));
        
        for(int i=0;i<listaLibroRegActas.size();i++){
        	row = sheet.createRow((short)W83bClsConstantes.DIECISEIS+i); // Creacin de la fila 1
        	
        	cell = row.createCell((short)0);
        	//la fecha la recibo como tipo char (fecha(yyyy-MM-dd) + hora) asi que lo formateo a mi gusto
        	String fechaChar=((W83bListadosBean)listaLibroRegActas.get(i)).getFechaEntrada();
        	if(StringUtils.isNotEmpty(fechaChar)){

	    		cell.setCellValue(fechaChar);
        	}else{
        		cell.setCellValue(fechaChar);
        	}
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	
        	cell = row.createCell((short)1);
        	StringBuffer numEntrada = new StringBuffer();//NOPMD
            if(StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getAnyoActa())){
            	numEntrada = new StringBuffer(((W83bListadosBean)listaLibroRegActas.get(i)).getTerritorio());//NOPMD
            	if(StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getTerritorio())){
            		numEntrada.append("/");
            	}
            	numEntrada.append(((W83bListadosBean)listaLibroRegActas.get(i)).getAnyoActa());
            	if(StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getNumActa())){
            		if (((W83bListadosBean)listaLibroRegActas.get(i)).getNumActa().length()==1){
            			numEntrada.append("/").append("00000").append(((W83bListadosBean)listaLibroRegActas.get(i)).getNumActa());
         			}else if (((W83bListadosBean)listaLibroRegActas.get(i)).getNumActa().length()==2){
         				numEntrada.append("/").append("0000").append(((W83bListadosBean)listaLibroRegActas.get(i)).getNumActa());
         			}else if (((W83bListadosBean)listaLibroRegActas.get(i)).getNumActa().length()==3){
         				numEntrada.append("/").append("000").append(((W83bListadosBean)listaLibroRegActas.get(i)).getNumActa());
         			}else if (((W83bListadosBean)listaLibroRegActas.get(i)).getNumActa().length()==4){
         				numEntrada.append("/").append("00").append(((W83bListadosBean)listaLibroRegActas.get(i)).getNumActa());
         			}else if (((W83bListadosBean)listaLibroRegActas.get(i)).getNumActa().length()==5){
         				numEntrada.append("/").append("0").append(((W83bListadosBean)listaLibroRegActas.get(i)).getNumActa());
         			}
         			else{
         				numEntrada.append("/").append(((W83bListadosBean)listaLibroRegActas.get(i)).getNumActa());
         			}
            	}
            }
        	cell.setCellValue(numEntrada.toString());
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	
        	cell = row.createCell((short)2); 
        	StringBuffer numPreaviso = new StringBuffer();//NOPMD
            if(StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getAnyoPreaviso())){
            	numPreaviso = new StringBuffer(((W83bListadosBean)listaLibroRegActas.get(i)).getTerritorio());//NOPMD
            	if(StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getTerritorio())){
            		numPreaviso.append("/");
            	}
            	numPreaviso.append(((W83bListadosBean)listaLibroRegActas.get(i)).getAnyoPreaviso());
            	if(StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getNumPreaviso())){
            		if (((W83bListadosBean)listaLibroRegActas.get(i)).getNumPreaviso().length()==1){
            			numPreaviso.append("/").append("00000").append(((W83bListadosBean)listaLibroRegActas.get(i)).getNumPreaviso());
         			}else if (((W83bListadosBean)listaLibroRegActas.get(i)).getNumPreaviso().length()==2){
         				numPreaviso.append("/").append("0000").append(((W83bListadosBean)listaLibroRegActas.get(i)).getNumPreaviso());
         			}else if (((W83bListadosBean)listaLibroRegActas.get(i)).getNumPreaviso().length()==3){
         				numPreaviso.append("/").append("000").append(((W83bListadosBean)listaLibroRegActas.get(i)).getNumPreaviso());
         			}else if (((W83bListadosBean)listaLibroRegActas.get(i)).getNumPreaviso().length()==4){
         				numPreaviso.append("/").append("00").append(((W83bListadosBean)listaLibroRegActas.get(i)).getNumPreaviso());
         			}else if (((W83bListadosBean)listaLibroRegActas.get(i)).getNumPreaviso().length()==5){
         				numPreaviso.append("/").append("0").append(((W83bListadosBean)listaLibroRegActas.get(i)).getNumPreaviso());
         			}
         			else{
         				numPreaviso.append("/").append(((W83bListadosBean)listaLibroRegActas.get(i)).getNumPreaviso());
         			}
            	}
            }
        	cell.setCellValue(numPreaviso.toString());
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	
        	cell = row.createCell((short)3); 
        	 if(StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getCif())){
        		 cell.setCellValue(((W83bListadosBean)listaLibroRegActas.get(i)).getCif());
        	 }
        	cell.setCellStyle(estiloFila(i,excel));
        	
        	cell = row.createCell((short)4); 
        	if(!StringUtils.isEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getNumCentro())){
            	cell.setCellValue(W83bUtilidades.numero(((W83bListadosBean)listaLibroRegActas.get(i)).getNumCentro()));
            }else{
            	cell.setCellValue("");
            }

        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	
        	cell = row.createCell((short)5); 
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISEIS+i,Short.parseShort("5"),W83bClsConstantes.DIECISEIS+i,Short.parseShort("6")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getRazon())){
        		cell.setCellValue(((W83bListadosBean)listaLibroRegActas.get(i)).getRazon().toUpperCase());
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(estiloFila(i,excel));
        	cell = row.createCell((short)6);
        	cell.setCellStyle(estiloFila(i,excel));
        	
        	cell = row.createCell((short)7);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISEIS+i,Short.parseShort("7"),W83bClsConstantes.DIECISEIS+i,Short.parseShort("8")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getDireccion())){
        		cell.setCellValue(((W83bListadosBean)listaLibroRegActas.get(i)).getDireccion().toUpperCase());
        	}else{
        		cell.setCellValue("");
        	}	
        	cell.setCellStyle(estiloFila(i,excel));
        	cell = row.createCell((short)8);
        	cell.setCellStyle(estiloFila(i,excel));
        	
        	cell = row.createCell((short)9);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISEIS+i,Short.parseShort("9"),W83bClsConstantes.DIECISEIS+i,Short.parseShort("10")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getMunicipio())){
        		cell.setCellValue(((W83bListadosBean)listaLibroRegActas.get(i)).getMunicipio().toUpperCase());
        	}else{
        		cell.setCellValue("");
        	}	
        	
        	cell.setCellStyle(estiloFila(i,excel));
        	cell = row.createCell((short)10);
        	cell.setCellStyle(estiloFila(i,excel));
        	
        	cell = row.createCell((short)11); 
        	HSSFCell cell2 = row.createCell(Short.parseShort("12")); 
        	sheet.addMergedRegion(new Region((short)W83bClsConstantes.DIECISEIS+i,Short.parseShort("11"),(short)W83bClsConstantes.DIECISEIS+i,Short.parseShort("12")));//NOPMD
        	if(!StringUtils.isEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getComarca())){
        		cell.setCellValue(((W83bListadosBean)listaLibroRegActas.get(i)).getComarca().toUpperCase());
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(estiloFila(i,excel));
        	cell2.setCellStyle(estiloFila(i,excel));
        	
        	cell = row.createCell((short)13);
        	if(!StringUtils.isEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getNumTrab())){
            	cell.setCellValue(W83bUtilidades.numero(((W83bListadosBean)listaLibroRegActas.get(i)).getNumTrab()));
            }else{
            	cell.setCellValue("");
            }
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	
        	cell = row.createCell((short)14); 
        	if (Integer.parseInt(((W83bListadosBean)listaLibroRegActas.get(i)).getNumrep())!=0){
        		cell.setCellValue(W83bUtilidades.numero(((W83bListadosBean)listaLibroRegActas.get(i)).getNumrep()));
        	}
        	else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	
        	int tamanyo = ((W83bListadosBean)listaLibroRegActas.get(i)).getRazon().length()/33;
        	
        	if(tamanyo<((W83bListadosBean)listaLibroRegActas.get(i)).getRazon().length()/37){
        		tamanyo = ((W83bListadosBean)listaLibroRegActas.get(i)).getRazon().length()/37;
        	}
        	if(!StringUtils.isEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getComarca())){
	        	if(tamanyo<((W83bListadosBean)listaLibroRegActas.get(i)).getComarca().length()/25){
	        		tamanyo = ((W83bListadosBean)listaLibroRegActas.get(i)).getComarca().length()/25;
	        	}       	
        	}
		    row.setHeightInPoints((short)(15*(tamanyo+1)));
        }
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoRequerimientosMesasActas.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	/**
	 * Estilo fila.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
	
	
	/**
	 * Estilo fila numero centrado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNumeroCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;//NOPMD
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
		
	}
}
